<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class UserData {

    static private function getUserIdKlasy() {
        return Yii::app()->user->getState('id_klasy');
    }

    public static function getCompaniesRanking($idKlasy) {
        $firmyKlasy = Yii::app()->db->createCommand('SELECT f."nazwa", pf."punkty" FROM "Firma" f RIGHT JOIN "PunktyFirmy" pf ON pf."idFirmy" = f."id" WHERE f."idKlasy" = ' . $idKlasy . ' AND rownum<=12 ORDER BY pf."punkty" DESC')->queryAll();
        $firmyKlasyStr = json_encode($firmyKlasy);
        Yii::app()->user->setState('firmy_klasy', $firmyKlasyStr);
        return $firmyKlasyStr;
    }

    public static function getSessionInfoArray() {
        $idKlasy = self::getUserIdKlasy();
        $valueId = 'client.class.' . $idKlasy;
        $value = Yii::app()->cache->get($valueId);

        if ($value === false) {
            $value = array();

            $value['userId'] = Yii::app()->user->id;

            $tasksToGo = Firma::getTasksToGoCount(Yii::app()->user->id_firmy);
            Yii::app()->user->setState('tasksToGo', $tasksToGo);
            $value['tasksToGo'] = $tasksToGo;

            $klasaModel = Klasa::model()->find('"id" = :id_klasy', array(':id_klasy' => $idKlasy));
            Yii::app()->user->setState('klasa', $klasaModel->nazwa);
            $value['klasa'] = $klasaModel->nazwa;

            $tura = Tura::model()->with(array('lekcja'))->find(array(
                'condition' => '"t"."idKlasy" = :idKlasy',
                'order' => '"t"."czasRozpoczecia" DESC',
                'params' => array(':idKlasy' => $idKlasy)
            ));

            $lessonNumber = empty($tura) ? 0 : $tura->lekcja->order;
            Yii::app()->user->setState('tura', $lessonNumber);
            $value['tura'] = $lessonNumber;

            $turaTrwa = !empty($tura) && (empty($tura->czasZakonczenia) || strtotime($tura->czasZakonczenia) >= time());
            Yii::app()->user->setState('tura_aktywna', $turaTrwa);
            $value['tura_aktywna'] = $turaTrwa;

            Akcja::pullActions($lessonNumber);
            Akcja::pullMissedForms($lessonNumber);

            $szkolaModel = Szkola::model()->find('"id" = :id_szkoly', array(':id_szkoly' => $klasaModel->idSzkoly));
            Yii::app()->user->setState('szkola', $szkolaModel->nazwa);
            $value['szkola'] = $szkolaModel->nazwa;

            $value['firmy_klasy'] = self::getCompaniesRanking($idKlasy);

            $lastAction = 0;
            if(Yii::app()->user->isStudent) {
                $userActions = AkcjaUzytkownika::model()->findAll(array('condition' => '"idFirmy" = :idFirmy',
                    'order' => '"dataWyslania" DESC', // idAkcji
                    'params' => array(':idFirmy' => Yii::app()->user->getState('id_firmy'))
                ));
                if (count($userActions) > 0) {
                    $lastAction = $userActions[0]->idAkcji;
                }
            }
            $value['ostatnia_akcja'] = $lastAction;

	    $ilosc_biur = count(BiuroFirmy::model()->findAll(array('condition' => '"idFirmy" = :idFirmy',
	    'params' => array(':idFirmy' => Yii::app()->user->getState('id_firmy')))));
	    $value['ilosc_biur'] = $ilosc_biur;

            Yii::app()->cache->set($valueId, $value, 10);
        } else {
            Yii::app()->user->setState('tura', $value['tura']);
            Yii::app()->user->setState('tura_aktywna', $value['tura_aktywna']);
            Yii::app()->user->setState('tasksToGo', $value['tasksToGo']);
            Yii::app()->user->setState('szkola', $value['szkola']);
            Yii::app()->user->setState('klasa', $value['klasa']);
        }

        return $value;
    }

    public static function getCompanyPoints($idFirmy) {
        $value = array();

        $punktyFirmy = Firma::model()->getPoints($idFirmy); // pobierane z widoku PunktyFirmy zaimplementowanego w bazie danych
        Yii::app()->user->setState('suma_punktow_firmy', $punktyFirmy);
        $value['suma_punktow_firmy'] = $punktyFirmy;

        $punkty = DziedzinaFirmy::model()->with(array('dziedzina'))->findAll('"idFirmy" = :id_firmy', array(':id_firmy' => $idFirmy));
        $punktyDziedzin = array('Chemia' => '0',
            'Matematyka' => '0',
            'Biologia' => '0',
            'Fizyka' => '0');
        foreach ($punkty as $row)
            $punktyDziedzin[$row->dziedzina->nazwa] = $row->punkty;

        $punktyChemia = $punktyDziedzin["Chemia"];
        Yii::app()->user->setState('punkty_chemia', $punktyChemia);
        $value['punkty_chemia'] = $punktyChemia;

        $punktyMatematyka = $punktyDziedzin["Matematyka"];
        Yii::app()->user->setState('punkty_matematyka', $punktyMatematyka);
        $value['punkty_matematyka'] = $punktyMatematyka;

        $punktyBiologia = $punktyDziedzin["Biologia"];
        Yii::app()->user->setState('punkty_biologia', $punktyBiologia);
        $value['punkty_biologia'] = $punktyBiologia;

        $punktyFizyka = $punktyDziedzin["Fizyka"];
        Yii::app()->user->setState('punkty_fizyka', $punktyFizyka);
        $value['punkty_fizyka'] = $punktyFizyka;

        return $value;
    }

    public static function getBusinessInfoArray() {
        $idFirmy = Yii::app()->user->getState('id_firmy');
        $valueId = 'client.business.' . $idFirmy;
        $value = Yii::app()->cache->get($valueId);
        if ($value === false) {
            $value = array();

            if ($idFirmy) {
                $firmaModel = Firma::model()->with(array('biuraIlosc'))->find('"t"."id" = :id_firmy', array(
                    ':id_firmy' => $idFirmy
                ));

                Yii::app()->user->setState('nazwa_firmy', $firmaModel->nazwa);
                $value['nazwa_firmy'] = $firmaModel->nazwa;

                $logoUrl = Yii::app()->baseUrl . '/' . (empty($firmaModel->urlLogo) ?
                                'images/gui/symbol-firma.png' : $firmaModel->urlLogo);
                Yii::app()->user->setState('logo_firmy', $logoUrl);
                $value['logo_firmy'] = $logoUrl;

                Yii::app()->user->setState('id_firmy', $firmaModel->id);
                $value['id_firmy'] = $firmaModel->id;

                Yii::app()->user->setState('ilosc_biur', $firmaModel->biuraIlosc);
                $value['ilosc_biur'] = $firmaModel->biuraIlosc;

                $dziedzinaFirmy = Dziedzina::model()->find('"id" = :id_dziedziny', array(':id_dziedziny' => $firmaModel->idDziedziny));
                $dziedzinaFirmyVal = !empty($dziedzinaFirmy) ? $dziedzinaFirmy->nazwa : '';
                Yii::app()->user->setState('dziedzina_firmy', $dziedzinaFirmyVal);
                $value['dziedzina_firmy'] = $dziedzinaFirmyVal;

                Yii::app()->user->setState('stan_konta', $firmaModel->stanKonta);
                $value['stan_konta'] = $firmaModel->stanKonta;

                //if ($firmaModel->alayzePayments())
                //{
                //	$firmaModel->save();
                //}

                Yii::app()->user->setState('status', (int) $firmaModel->status);
                $value['status'] = (int) $firmaModel->status;
            }

            $users = Yii::app()->db->createCommand('
				select u."id", u."imie", u."nazwisko", nvl(uo."obecny", 1) "obecny" from "Uzytkownik" u
				left join "UzytkownikObecnosc" uo on uo."idUzytkownika" = u."id" and uo."idTury" in (select * from (
					select "t"."id" from "Tura" "t" where "t"."idKlasy" = :idKlasy order by "t"."czasRozpoczecia" DESC
				) where rownum <= 1)
				where u."id" <> :userId and u."idFirmy" = :companyId
			')->queryAll(true, array(
                ':userId' => Yii::app()->user->id,
                ':idKlasy' => Yii::app()->user->id_klasy,
                ':companyId' => Yii::app()->user->id_firmy,
            ));
            $iloscPozostalych = count($users);
            Yii::app()->user->setState('ile_czlonkow', $iloscPozostalych);
            $value['ile_czlonkow'] = $iloscPozostalych;
            if ($iloscPozostalych < 1) {
                Yii::app()->user->setState('grupa', "");
                $value['grupa'] = '';
            } else {
                foreach ($users as $idx => $user)
                    $users[$idx]['obecny'] = (int) $user['obecny'];
                $grupuString = json_encode($users);
                Yii::app()->user->setState('grupa', $grupuString);
                $value['grupa'] = $grupuString;
            }

            $value = $value + self::getCompanyPoints($idFirmy);

            Yii::app()->cache->set($valueId, $value, 10);
        }
        return $value;
    }

    public static function getNewsHeadlinesJsonString() {
        $valueId = 'client.news.' . self::getUserIdKlasy() . '.' . Yii::app()->user->id;
        $value = Yii::app()->cache->get($valueId);
        if ($value === false) {
            $naglowkiWiadomosci = Yii::app()->db->cache(0)->createCommand('SELECT
					a."idLekcji", nvl(au."naglowek", a."naglowek") "naglowek",
					nvl(au."tresc", a."tresc") "tresc", au."dataWykonania",
					au."id", au."dataWyslania", a."czyOglaszac", au."przeczytana"
				FROM "Akcja" a
				RIGHT JOIN "AkcjaUzytkownika" au ON au."idAkcji" = a."id"
				WHERE ((a."idLekcji" <= :tura and a."idLekcji" > 0) or (a."idLekcji" = -1 and :tura = -1)) AND
				a."czyWiadomosc" = 1 AND au."idUzytkownika" = :user_id
				ORDER BY au."dataWyslania" DESC, au."id" DESC'
                    )->queryAll(true, array(
                ':tura' => Yii::app()->user->tura,
                ':user_id' => Yii::app()->user->id
            ));

			foreach($naglowkiWiadomosci as &$naglowek)
				$naglowek['tresc'] = OracleHelper::getClobValue('"AkcjaUzytkownika"', '"tresc"', '"id"', $naglowek['id']);

            $value = json_encode($naglowkiWiadomosci);
            Yii::app()->user->setState('naglowki_wiadomosci', $value);
            Yii::app()->cache->set($valueId, $value, 10);
        }
        return $value;
    }

    public static function getStudentActionJsonString() {
        //$valueId = 'client.news.' . self::getUserIdKlasy() . '.' . Yii::app()->user->id;
        //$value = Yii::app()->cache->get($valueId);
        //if ($value === false)
		{
			/*
            $naglowkiakcji = Yii::app()->db->cache(0)->createCommand('SELECT DISTINCT
  "AkcjaUzytkownika"."idAkcji","AkcjaUzytkownika"."idUzytkownika","AkcjaUzytkownika"."idFirmy","Akcja"."naglowek"
                    FROM
                      "AkcjaUzytkownika"
                    LEFT JOIN
                      "Akcja" ON "AkcjaUzytkownika"."idAkcji"="Akcja"."id"
                    LEFT JOIN
                      "Klasa" ON "AkcjaUzytkownika"."id"="Klasa"."id"
                    WHERE
                      "AkcjaUzytkownika"."przeczytana"=1
                    AND
                      "Akcja"."czyOglaszac"=1'
                    )->queryAll(true, array(
            ));
			*/

			$sql = 'SELECT
						"t"."naglowek"
					FROM
						"AkcjaUzytkownika" "t"
					LEFT OUTER JOIN
						"Akcja" "akcja" ON ("akcja"."id" = "t"."idAkcji")
					WHERE
						"akcja"."czyOglaszac" = 1
					AND
						"t"."przeczytana"=1
					AND
						"t"."idFirmy" IN (SELECT "id" FROM "Firma" WHERE "idKlasy" = :id_klasy)
					ORDER BY
						"t"."id" DESC';

			$idKlasy = Yii::app()->user->id_klasy;

			$naglowkiAkcji = Yii::app()->db->createCommand($sql)->bindParam(':id_klasy', $idKlasy)->limit(15)->queryColumn();
            Yii::app()->user->setState('naglowki_akcji', $naglowkiAkcji);

            $value = json_encode($naglowkiAkcji);
        }
        return $value;
    }

    public static function getBuildingsJsonString($mapId = 1) {
        $valueId = 'client.buildings.' . $mapId;
        $value = Yii::app()->cache->get($valueId);
        if ($value === false) {
            $budynki = Budynek::model()->cache(0)->findAll('"idMapy" = :mapId', array(':mapId' => $mapId));
            $result = array();
            foreach ($budynki as $bud)
                $result[$bud->nazwa] = array(
                    'opis' => $bud->opis,
                    'adres' => $bud->adres,
                    'urlLogo' => $bud->urlLogo,
                    'rodzajBudynku' => $bud->rodzajBudynku->typ, //idRodzajuBudynku;
                    'id' => $bud->id
                );
            $value = json_encode($result);
            Yii::app()->user->setState('budynki', $value);
            Yii::app()->cache->set($valueId, $value, 10);
        }
        return $value;
    }

    private static $_occupiedOffices;

    static private function &getOccupiedOfficesArray() {
        if (self::$_occupiedOffices == null) {
            $zajeteBiura = Yii::app()->db->cache(0)->createCommand('SELECT b."idBudynku",f."id" AS "idFirmy",f."nazwa" AS "nazwaFirmy",f."urlLogo" FROM "Biuro" b
												RIGHT JOIN "BiuroFirmy" bf ON b."id" = bf."idBiura"
												LEFT JOIN "Firma" f ON f."id" = bf."idFirmy"
												WHERE f."idKlasy" = ' . self::getUserIdKlasy())->queryAll();
            $tablicaZajetych = array();
            foreach ($zajeteBiura as $zb) {
                $tablicaZajetych[$zb['idBudynku']]["idFirmy"] = $zb['idFirmy'];
                $tablicaZajetych[$zb['idBudynku']]["nazwaFirmy"] = $zb['nazwaFirmy'];
                $tablicaZajetych[$zb['idBudynku']]["urlLogo"] = $zb['urlLogo'];
            }
            self::$_occupiedOffices = $tablicaZajetych;
        }
        return self::$_occupiedOffices;
    }

    public static function getOfficesJsonString() {
        $valueId = 'client.offices.' . self::getUserIdKlasy();
        $value = Yii::app()->cache->get($valueId);
        if ($value === false) {
            $tablicaZajetych = & self::getOccupiedOfficesArray();
            $biura = Biuro::model()->cache(0)->findAll();
            $tablicaBiur = array();
            foreach ($biura as $biu) {
                $tablicaBiur[$biu->idBudynku]["powierzchnia"] = $biu->powierzchnia;
                $tablicaBiur[$biu->idBudynku]["maxPracownikow"] = $biu->maxPracownikow;
                $tablicaBiur[$biu->idBudynku]["cenaWynajem"] = $biu->cenaWynajem;
                $tablicaBiur[$biu->idBudynku]["cenaMedia"] = $biu->cenaMedia;
                $tablicaBiur[$biu->idBudynku]["idFirmy"] = isset($tablicaZajetych[strval($biu->idBudynku)]) ? $tablicaZajetych[strval($biu->idBudynku)]["idFirmy"] : '';
                $tablicaBiur[$biu->idBudynku]["nazwaFirmy"] = isset($tablicaZajetych[strval($biu->idBudynku)]) ? $tablicaZajetych[strval($biu->idBudynku)]["nazwaFirmy"] : '';
                $tablicaBiur[$biu->idBudynku]["urlLogo"] = isset($tablicaZajetych[strval($biu->idBudynku)]) ? $tablicaZajetych[strval($biu->idBudynku)]["urlLogo"] : '';
            }
            $value = json_encode($tablicaBiur);
            Yii::app()->user->setState('biura', $value);
            Yii::app()->cache->set($valueId, $value, 10);
        }
        return $value;
    }

    public static function getBanksJsonString() {
        $valueId = 'client.banks';
        $value = Yii::app()->cache->get($valueId);
        if ($value === false) {
            $banki = Bank::model()->cache(0)->findAll();
            $tablicaBankow = array();
            foreach ($banki as $b) {
                $tablicaBankow[$b->nazwa]["nazwa"] = $b->nazwa;
                $tablicaBankow[$b->nazwa]["idBudynku"] = $b->idBudynku;
                $tablicaBankow[$b->nazwa]["oplataZalozenie"] = $b->oplataZalozenie;
                $tablicaBankow[$b->nazwa]["oplataMiesieczna"] = $b->oplataMiesieczna;
                $tablicaBankow[$b->nazwa]["oplataPrzelew"] = $b->oplataPrzelew;
                $tablicaBankow[$b->nazwa]["oprocentowanie"] = $b->oprocentowanie;
                $tablicaBankow[$b->nazwa]["opis"] = $b->opis;
            }
            $value = json_encode($tablicaBankow);
            Yii::app()->user->setState('banki', $value);
            Yii::app()->cache->set($valueId, $value, 10);
        }
        return $value;
    }

    public static function getKontrahenciJsonString() {
        $valueId = 'client.kontrahenci';
        $value = Yii::app()->cache->get($valueId);
        if ($value === false) {
            $kontrahenci = Kontrahent::model()->cache(0)->with(array('dziedzina'))->findAll();
            $tablicaKontrahentow = array();
            foreach ($kontrahenci as $k) {
                $tablicaKontrahentow[$k->idBudynku]["id"] = $k->id;
                $tablicaKontrahentow[$k->idBudynku]["nazwa"] = $k->nazwa;
                $tablicaKontrahentow[$k->idBudynku]["urlLoga"] = $k->urlLoga;
                $tablicaKontrahentow[$k->idBudynku]["NIP"] = $k->NIP;
                $tablicaKontrahentow[$k->idBudynku]["REGON"] = $k->REGON;
                $tablicaKontrahentow[$k->idBudynku]["adres"] = $k->adres;
                $tablicaKontrahentow[$k->idBudynku]["nrKonta"] = $k->nrKonta;
                $tablicaKontrahentow[$k->idBudynku]["typ"] = $k->typ;
                $tablicaKontrahentow[$k->idBudynku]["dziedzina"] = $k->dziedzina->nazwa;
            }
            $value = json_encode($tablicaKontrahentow);
            Yii::app()->user->setState('kontrahenci', $value);
            Yii::app()->cache->set($valueId, $value, 10);
        }
        return $value;
    }

}
